INSTRUCTIONS.md

Overview

This guide shows how to turn any Linux workstation into an Encryption Honeypot that lures surveillance tools into costly, dead‑end crypto puzzles. The monthly theme is “Guerrilla Encryption: Making the Cipher the Prize.”

You will end up with a web‑accessible directory (/honeypot/) that contains:

    Encrypted conversation bundles (easy entry points).
    Self‑destructing bundles that expire after a configurable number of days.
    A snowflake‑shaped puzzle network (entry rooms, bridge rooms, a layered Diffie‑Hellman trap, and a high‑value vault).
    A public‑key directory (/honeypot/keys/) that includes your weekly and monthly public keys, a sample key for verification, and optional activist keys.

The steps are ordered so you can run each script once and move on. If you ever need to redo a step, just delete the generated files and rerun the script.

1. Domain & VPN (one‑time setup)

    Register a short domain (or use a sub‑domain you already own).
    Point an A record at the public IP of your VPS.
    Route all traffic through a VPN (WireGuard, OpenVPN, or any service you trust) so the VPS’s IP stays hidden from casual scans.

You only need to do this once per deployment.

2. Install a web server and HTTPS

Choose nginx or Apache. The commands below work on Linux; adjust the package names as you see fit.

nginx

sudo apt update
sudo apt install nginx certbot python3-certbot-nginx
sudo certbot --nginx -d yourdomain.com -d www.yourdomain.com
sudo systemctl enable --now nginx

Apache

sudo apt update
sudo apt install apache2 certbot python3-certbot-apache
sudo certbot --apache -d yourdomain.com -d www.yourdomain.com
sudo systemctl enable --now apache2

Both commands obtain a free Let’s Encrypt certificate and configure HTTPS automatically.

3. Create the web folder structure

Adjust the path if your document root differs

sudo mkdir -p /var/www/html/honeypot
sudo chown $USER:$USER /var/www/html/honeypot
sudo chmod 755 /var/www/html/honeypot

If you are on a cPanel host, create the folder via File Manager inside public_html.

4. Generate the cryptographic keys

Run the script generate_keys.sh. It will ask for two passphrases: a modest one for the weekly RSA 2048 key and a strong, random one for the monthly RSA 4096 (or Ed25519) key.

chmod +x scripts/generate_keys.sh
./scripts/generate_keys.sh

The script places the public keys in web/honeypot/keys/weekly_pub.asc and monthly_pub.asc. Keep the private keys offline (e.g., on an encrypted USB).

5. Create random OTP fragments

chmod +x scripts/make_fragments.sh
./scripts/make_fragments.sh

You will get a set of files frag_01.bin … frag_12.bin inside web/honeypot/fragments/. These are the “baits” hidden inside the puzzle rooms.

6. Build encrypted‑conversation bundles

The script bundle_conversations.sh creates PGP‑armored files that look like chat logs. By default it makes one bundle; give it a number to create more.

chmod +x scripts/bundle_conversations.sh
./scripts/bundle_conversations.sh 5   # creates five bundles

The resulting files (bundle_01.asc, …) appear in web/honeypot/. They are encrypted with the weekly RSA 2048 key.

7. Add self‑destruct handling

This script renames each bundle to include an expiration tag and installs a daily cron job that removes expired files and makes the server return 410 Gone.

chmod +x scripts/create_self_destruct.sh
sudo ./scripts/create_self_destruct.sh

You can change the lifetime by editing the LIVE_DAYS variable near the top of the script (default 30 days).

8. Assemble the snowflake puzzle network

Run build_snowflake.sh to create the non‑linear rooms: entry bundles, bridge bundles (require two fragments), the layered Diffie‑Hellman trap (Room 3A), and the high‑value vault (encrypted with the monthly key).

chmod +x scripts/build_snowflake.sh
./scripts/build_snowflake.sh

All new .asc files (entry_*.asc, bridge_*.asc, core_room.asc, vault_room.asc) land in web/honeypot/.

9. (Optional) Restrict access by country

If you want only certain countries to see the honeypot, run geoip_gate.sh and list the ISO‑3166‑1 alpha‑2 codes you wish to allow.

chmod +x scripts/geoip_gate.sh
sudo ./scripts/geoip_gate.sh US CA   # allow United States and Canada

The script installs the free GeoLite2‑Country database, enables the appropriate module for nginx or Apache, writes a config snippet, and reloads the web server.

To open the honeypot to everyone later, run:

sudo ./scripts/geoip_gate.sh ALL

10. Rotate the monthly vault (once per month)

When a new month starts, generate a fresh RSA 4096 key, pick new fragments, and rebuild the vault.

chmod +x scripts/rotate_monthly.sh
./scripts/rotate_monthly.sh

The script archives the old vault and its public key, updates CHANGELOG.txt, and writes a new vault_room.asc encrypted with the new monthly key.

11. Add supporting files
Sample bundle

A tiny pre‑generated bundle (sample_bundle.asc) is included for verification. Decrypt it with the sample public key:

gpg --import web/honeypot/keys/sample_pub.asc
gpg --output sample_decrypted.txt --decrypt web/honeypot/sample_bundle.asc
cat sample_decrypted.txt

Sample public key

sample_pub.asc lives in web/honeypot/keys/. It’s only the public part, so there’s no security risk.
Activist keys (optional)

If you have activist public keys, place each one in web/honeypot/keys/ (e.g., activist_alice.asc). Add a line for each key in keys/index.txt with its fingerprint and a short label.
README.txt

A short description of the honeypot is already in web/honeypot/README.txt. It explains the theme, the expiration mechanic, and points visitors to the keys/ folder.
index.html (optional)

If you prefer a minimal landing page instead of a raw directory listing, copy the index.html we drafted into web/honeypot/. It’s plain HTML with a few lines of CSS, fully accessible.

12. Test the whole setup

    Check the web directory

    curl -I https://yourdomain.com/honeypot/

    You should see 200 OK and a list of the .asc files.

    Decrypt a bundle

    gpg --import web/honeypot/keys/weekly_pub.asc
    gpg --output test.txt --decrypt web/honeypot/bundle_01.asc
    cat test.txt

    You should see the chat log and the attached fragment.

    Verify expiration

    Look at a filename like bundle_01_Expires-20260228.asc. Fast‑forward your system clock past that date (or wait), then request the file again:

    curl -I https://yourdomain.com/honeypot/bundle_01_Expires-20260228.asc

    The response should be 410 Gone.

    Check country gating (if enabled)

    From a machine outside the allowed list, request the directory. You should receive 403 Forbidden. From an allowed country you get 200 OK.

If any step fails, revisit the corresponding script output; each script prints a short status line for every file it creates.

13. Ongoing maintenance

    Rotate the monthly vault at the start of each month (rotate_monthly.sh).
    Adjust expiration by editing LIVE_DAYS in create_self_destruct.sh and rerunning it.
    Update activist keys by adding new *_pub.asc files to keys/ and appending a line to keys/index.txt.
    Refresh the GeoIP database occasionally (sudo apt update && sudo apt install libmaxminddb0) to keep country mapping accurate.


14. Troubleshooting quick tips

    Missing nginx or apache2 module errors – ensure the relevant package (nginx-module-geoip2 or apache2-mod-maxminddb) is installed.
    Cron job not running – verify the file /etc/cron.d/honeypot_selfdestruct exists and contains the line 0 2 * * * root /usr/local/bin/honeypot_cleanup.sh.
    Fingerprint mismatch – run gpg --list-keys --with-fingerprint and compare the output to the entries in keys/index.txt.
    403/410 responses when you expect 200 – double‑check the country list in geoip_gate.sh and the expiration dates in the filenames.

15. Closing note

All the commands above are written for a generic Linux workstation. They avoid unnecessary jargon, use plain‑text files, and keep the flow linear so you can follow each step without backtracking. Once the honeypot is live, you’ll have a functional, low‑cost trap that turns the cipher itself into the prize and gathers useful telemetry on anyone trying to pry into your data.

Good luck, and may the puzzles keep the adversaries busy!