#!/usr/bin/env python3
"""
telemetry_noise.py
-----------------
Synthetic system‑telemetry generator.

Features
--------
* Optional external pools:
    - process_names.txt   → fake process names
    - dns_domains.txt     → domains for dummy DNS queries
    - sensor_names.txt    → sensor identifiers
  If any file is missing or empty, a built‑in fallback list is used.
* Four event types:
    1. Process snapshot   (PID, name, CPU %, MEM MB)
    2. DNS lookup        (runs a silent `dig` if available)
    3. Sensor reading    (random value per sensor)
    4. Hardware metric   (battery, uptime, IP, load, temps)
* Randomised intervals per event type to avoid a regular cadence.
* Graceful shutdown on SIGINT / SIGTERM.
* Line‑buffered output (important for the orchestrator).
"""

import os
import random
import signal
import socket
import subprocess
import sys
import time
from pathlib import Path
from typing import List

# ------------------------------------------------------------
# 1️⃣  CONFIGURATION (tweak if you need different pacing)
# ------------------------------------------------------------
SCRIPT_DIR = Path(__file__).parent.resolve()

# Interval ranges (seconds) – min / max between consecutive events
PROC_INTERVAL   = (30, 90)    # process snap